<?php
try {
    $file = './settings.json';
    if(file_exists($file)){
        $data = file_get_contents($file);
        $json_data = json_decode($data, true);
        if( isset( $json_data['showAdvertisment'] ) ){
            $showAdvertisment=$json_data["showAdvertisment"];
         }else{
            $showAdvertisment=false;
         }
         if( isset( $json_data['advertismentImage'] ) ){
            $advertismentImage=$json_data["advertismentImage"];
         }else{
            $advertismentImage=false;
         }
       
    }else{
        $showAdvertisment=false;
        $advertismentImage=false;
    }
}catch(Exception $e){
    $showAdvertisment=false;
    $advertismentImage=false;
}

?>



<?php
// [PHP code remains unchanged]
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
    <title>Via Dbayeh</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <style>
        /* Updated color scheme */
        :root {
            --via-primary: #8C1D40;    /* Burgundy from buttons */
            --via-accent: #D4AF37;      /* Gold accent color */
            --via-light: #F8F5F0;       /* Light cream background */
        }
        
        @font-face {
            font-family: 'ViaFont';
            src: url('assets/fonts/Acumin-RPro.otf');
            font-weight: normal;
            font-style: normal;
        }

        body {
            background-image: url('assets/imgs/bg1.webp');
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center top;
            min-height: 100vh;
            width: 100%;
            font-family: 'ViaFont', sans-serif;
        }

        .menu-link {
            width: 90%;
            padding: 1px;
            transition: transform 0.3s ease;
        }

        .menu-link:hover {
            transform: translateY(-3px);
        }

        /* Modal styling with Via colors */
        #Admodal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.9);
        }

        .modal-content {
            margin: 15% auto;
            display: block;
            width: 80%;
            max-width: 700px;
            max-height: 70vh;
            object-fit: contain;
        }

        #caption {
            text-align: center;
            color: var(--via-light);
            padding: 15px 0;
            font-size: 1.5rem;
            letter-spacing: 2px;
            text-transform: uppercase;
        }

        .close {
            color: var(--via-light);
            font-size: 40px;
            transition: color 0.3s;
        }

        .close:hover,
        .close:focus {
            color: var(--via-accent);
        }

        #first_row {
            margin-top: 220px;
        }

        /* Responsive adjustments */
        @media (max-width: 700px) {
            #first_row {
                margin-top: 180px;
            }
            
            .modal-content {
                width: 95%;
                margin-top: 30%;
            }
            
            #caption {
                font-size: 1.2rem;
            }
        }

        @media (max-width: 575px) {
            #first_row {
                margin-top: 150px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-5 col-sm-8" style="margin-top: 30px; margin-bottom: 40px">
                <!-- Menu items with proper spacing -->
                <div class="row justify-content-center" id="first_row">
                    <a href="https://emenu.intoweb.me/via_american" class="btn menu-link mb-3">
                        <img src="./assets/imgs/asset 8.png" class="img-fluid" alt="American">
                    </a>
                </div>
                <div class="row justify-content-center">
                    <a href="https://emenu.intoweb.me/via_italian" class="btn menu-link mb-3">
                        <img src="./assets/imgs/via_it.png" class="img-fluid" alt="Italian">
                    </a>
                </div>
                <div class="row justify-content-center">
                    <a href="https://emenu.intoweb.me/via_japanese" class="btn menu-link mb-3">
                        <img src="./assets/imgs/via_jp.png" class="img-fluid" alt="Japanese">
                    </a>
                </div>
                <div class="row justify-content-center">
                    <a href="https://emenu.intoweb.me/via_lebanese" class="btn menu-link mb-3">
                        <img src="./assets/imgs/via_lb.png" class="img-fluid" alt="Lebanese">
                    </a>
                </div>
                <div class="row justify-content-center">
                    <a href="https://emenu.intoweb.me/via_bar" class="btn menu-link mb-3">
                        <img src="./assets/imgs/via_bar.png" class="img-fluid" alt="Bar & Beverages">
                    </a>
                </div>
                <div class="row justify-content-center">
                    <a href="https://emenu.intoweb.me/via_shisha" class="btn menu-link">
                        <img src="./assets/imgs/via_shisha.png" class="img-fluid" alt="Shisha">
                    </a>
                </div>
            </div>
        </div>
 
        <!-- Advertisement Modal -->
        <div id="Admodal" class="modal">
            <span class="close">&times;</span>
            <?php if($advertismentImage === false): ?>
                <img class="modal-content" src="assets/imgs/no_image.png" id="adImg">
            <?php else: ?>
                <img class="modal-content" src="assets/imgs/<?= $advertismentImage ?>" id="adImg">
            <?php endif; ?>
            <div id="caption">VIA Dbayeh</div>
        </div>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function() {
                const modal = document.getElementById("Admodal");
                const showAd = <?= (int)$showAdvertisment ?>;
                
                if(showAd) {
                    modal.style.display = "block";
                }
                
                // Close modal
                document.querySelector('.close').addEventListener('click', () => {
                    modal.style.display = "none";
                });
                
                // Close when clicking outside content
                window.addEventListener('click', (e) => {
                    if (e.target === modal) {
                        modal.style.display = "none";
                    }
                });
            });
        </script>
</body>
</html>